from PySide6.QtCore import QObject, Signal

class TranslationManager(QObject):
    # Signal emitted when language changes
    language_changed = Signal(str)
    
    def __init__(self):
        super().__init__()
        # Default language is Chinese
        self._current_language = "chinese"
        # Initialize translations dictionary
        self._translations = {
            "chinese": {},
            "english": {}
        }
        # Load translations
        self._initialize_translations()
        
    def _initialize_translations(self):
        """Initialize the translations dictionary with all text that needs to be translated"""
        # Main window
        self._add_translation("main_title", "文件禅AI文件归档工具", "FileNeatAI File Archiving Tool")
        
        # Page 1 (文件整理)
        self._add_translation("organize_files", "文件整理", "File Organization")
        self._add_translation("select_folder", "选择文件夹", "Select Folder")
        self._add_translation("cancel", "取消", "Cancel")
        self._add_translation("next", "下一步", "Next")
        self._add_translation("drag_folder", "拖入文件夹，或者", "Drag a folder, or")
        self._add_translation("organize_messy_folders", "对杂乱的文件夹进行归类整理", "Organize messy folders with AI classification")
        self._add_translation("storage_path", "存放路径：", "Storage Path:")
        self._add_translation("classify_existing", "基于已有文件夹分类", "Classify based on existing folders")
        self._add_translation("file_org_mode", "文件整理模式：", "File Organization Mode:")
        self._add_translation("image_class_mode", "图片分类模式：", "Image Classification Mode:")
        self._add_translation("content", "内容", "Content")
        self._add_translation("type", "类型", "Type")
        self._add_translation("size", "大小", "Size")
        self._add_translation("creation_time", "创建时间", "Creation Time")
        self._add_translation("filename", "文件名", "Filename")
        self._add_translation("visual_analysis", "视觉分析", "Visual Analysis") 
        self._add_translation("ocr_recognition", "OCR识别", "OCR Recognition")
        self._add_translation("copy", "复制", "Copy")
        self._add_translation("move", "移动", "Move")
        self._add_translation("quchong", "文件去重:", "File deduplication:")
        self._add_translation("yes", "是", "yes")
        self._add_translation("no", "否", "no")
        self._add_translation("custom_prompt", "自定义提示词：", "Custom Prompt:")
        self._add_translation("please_select", "请选择", "Please Select")
        self._add_translation("reference_options", "参考选项：", "Reference Options:")
        self._add_translation("preparing", "准备中!", "Preparing!")
        self._add_translation("send", "发送", "Send")
        self._add_translation("file_list", "文件列表", "File List")
        self._add_translation("operations", "操作", "Operations")
        
        # Page 2 (重命名)
        self._add_translation("rename", "重命名", "Rename")
        self._add_translation("select_files", "选择文件", "Select Files")
        self._add_translation("start_rename", "开始重命名", "Start Rename")
        self._add_translation("please_select_files", "请先选择文件", "Please select files first")
        self._add_translation("invalid_config", "无效的配置选项", "Invalid configuration options")
        self._add_translation("renaming_files", "正在重命名", "Renaming")
        self._add_translation("files_count", "个文件，请稍等…", "files, please wait...")
        self._add_translation("retry", "重试中!...", "Retrying!...")
        self._add_translation("ai_naming", "AI命名", "AI Naming")
        self._add_translation("selected_files_count", "已选择{0}个支持的文件", "{0} supported files selected")
        self._add_translation("naming_standards", "命名标准（非必选）：", "Naming Standards (Optional):")
        self._add_translation("custom_prompt_optional", "自定义提示词（非必选）：", "Custom Prompt (Optional):")
        self._add_translation("please_enter", "请输入...", "Please enter...")
        self._add_translation("clear", "清空", "Clear")
        self._add_translation("no_files_selected", "没有选择任何文件", "No files selected")
        
        # Settings page
        self._add_translation("settings", "个人设置", "Settings")
        self._add_translation("online_model", "在线模型:", "Online Model:")
        self._add_translation("local_model", "本地模型", "Local Model")
        self._add_translation("online_model_label", "在线模型:", "Online Model:")
        self._add_translation("local_model_label", "本地模型:", "Local Model:")
        self._add_translation("machine_code", "机器码", "Machine Code")
        self._add_translation("api_server", "API Server", "API Server")
        self._add_translation("api_key", "API Key", "API Key")
        self._add_translation("model_name", "模型名", "Model Name")
        self._add_translation("model_name_dropdown", "模型名:", "Model Name:")
        self._add_translation("model_name_choose", "模型选择:", "choose Model:")
        self._add_translation("language", "语言", "Language")
        self._add_translation("tesseract_path", "Tesseract路径", "Tesseract Path")
        self._add_translation("thread_count", "线程数:", "Thread Count:")
        self._add_translation("thread_count_placeholder", "默认: 4", "Default: 4")
        self._add_translation("save", "保存", "Save")
        self._add_translation("save_success", "保存成功！", "Save successful!")
        self._add_translation("vip", "VIP：", "VIP:")
        self._add_translation("visit_website", "前往官网", "Visit Website")
        self._add_translation("recharge", "充值", "Recharge")
        self._add_translation("remaining_count", "在线模型剩余数量: {0}, 本地模型已解锁", "Online model remaining: {0}, Local model unlocked")
        self._add_translation("code_copied", "机器码已复制到剪贴板！", "Machine code copied to clipboard!")
        
        # Home page elements
        self._add_translation("super", "超级", "Super")
        self._add_translation("file_archive", "文件归档", "File Archive")
        self._add_translation("tool", "工具", "Tool")
        self._add_translation("start_organizing", "开始整理", "Start Organizing")
        self._add_translation("select_file_to_come", "选择文件来", "Select file to come")
        self._add_translation("proceed_organize", "进行文件整理", "Proceed with file organization")
        self._add_translation("home_description", "专业的跨平台AI文件整理工具---文件禅你的文件，AI来管理", 
                             "Professional cross-platform AI file organization tool---FileNeatAI, your files, managed by AI")
        
        # Dialogs and messages
        self._add_translation("loading", "加载中...", "Loading...")
        self._add_translation("file_loading", "文件加载中...", "File loading...")
        self._add_translation("file_processed", "文件处理完成", "File Processing Complete")
        self._add_translation("error", "错误", "Error")
        self._add_translation("success", "成功", "Success")
        self._add_translation("warning", "警告", "Warning")
        self._add_translation("confirm", "确认", "Confirm")
        self._add_translation("确认整理", "确认整理", "Confirm Organization")
        self._add_translation("整理中", "整理中", "Organizing")
        self._add_translation("文件分类结果", "文件分类结果", "File Classification Result")
        self._add_translation("processing_complete", "处理完成", "Processing Complete")
        self._add_translation("choose_file_path", "请先选择输出文件夹路径", "Please select the output folder path first")
        self._add_translation("alert", "提示", "Alert")
        self._add_translation("file_limit_reached", "已达到文件数量上限", "File limit reached")
        self._add_translation("cannot_add_more", "不能添加更多文件", "Cannot add more files")
        self._add_translation("file_not_found", "文件或目录不存在", "File or directory not found")
        self._add_translation("cannot_open_folder", "无法打开文件夹", "Could not open folder")
        self._add_translation("loading_folder_error", "加载文件夹时出错", "Error loading folder")
        self._add_translation("no_processable_files", "没有找到可处理的文件", "No processable files found")
        self._add_translation("update_required", "强制更新！", "Update Required!")
        self._add_translation("update_message", "当前版本不是最新版本，请前往官网下载最新版本！", "This version is not the latest. Please download the latest version from the official website!")
        self._add_translation("update_suggested", "提示", "Notice")
        self._add_translation("update_suggested_msg", "当前版本不是最新版本，请前往官网下载最新版本！", "This version is not the latest. Consider downloading the latest version from the official website.")
        self._add_translation("name", "名称", "Name")
        self._add_translation("info", "信息", "Info")
        
        # Additional UI elements
        self._add_translation("delete", "删除", "Delete")
        self._add_translation("refresh", "刷新", "Refresh")
        self._add_translation("open_folder", "打开文件夹", "Open Folder")
        self._add_translation("contact_us", "联系我们", "Contact Us")
        self._add_translation("guide", "新手指引", "Guide")
        self._add_translation("description", "文件禅：专业的跨平台AI文件整理工具。你的文件，文件禅来管理", "FileNeatAI: Professional cross-platform AI file organization tool. Your files, managed by FileNeatAI")
        
        # UI elements from retranslateUi (keeping for compatibility)
        self._add_translation("ui_文件禅AI文件归档工具", "文件禅AI文件归档工具", "FileNeatAI File Archiving Tool")
        self._add_translation("ui_文件整理", "  文件整理", "  File Organization")
        self._add_translation("ui_重命名", "  重命名", "  Rename")
        self._add_translation("ui_个人设置", "  个人设置", "  Settings")
        self._add_translation("ui_联系我们", "联系我们", "Contact Us")
        self._add_translation("ui_超级", "超级", "Super")
        self._add_translation("ui_文件归档", "文件归档", "File Archive")
        self._add_translation("ui_工具", "工具", "Tool")
        self._add_translation("ui_文件禅：专业的跨平台AI文件整理工具。你的文件，文件禅来管理", "文件禅：专业的跨平台AI文件整理工具。你的文件，文件禅来管理", "FileNeatAI: Professional cross-platform AI file organization tool. Your files, managed by FileNeatAI")
        self._add_translation("ui_选择文件夹", "选择文件夹", "Select Folder")
        self._add_translation("ui_自定义提示词", "自定义提示词", "Custom Prompt")
        self._add_translation("ui_开始整理", "开始整理", "Start Organizing")
        self._add_translation("ui_对杂乱的文件夹进行归类整理，这是一句文案", "对杂乱的文件夹进行归类整理，这是一句文案", "Organize messy folders with AI classification")
        self._add_translation("ui_拖入文件夹，或者", "拖入文件夹，或者", "Drag a folder, or")
        self._add_translation("ui_进行文件整理", "进行文件整理", "Organize Files")
        self._add_translation("ui_存放路径：", "存放路径：", "Storage Path:")
        self._add_translation("ui_基于已有文件夹分类", "基于已有文件夹分类", "Classify based on existing folders")
        self._add_translation("ui_文件夹分类模式", "文件夹分类模式", "Folder Classification Mode")
        self._add_translation("ui_存储路径", "存储路径: ", "Storage path:")
        self._add_translation("ui_文件整理模式：", "文件整理模式：", "File Organization Mode:")
        self._add_translation("ui_图片分类模式：", "图片分类模式：", "Image Classification Mode:")
        self._add_translation("ui_内容", "内容", "Content")
        self._add_translation("ui_类型", "类型", "Type")
        self._add_translation("ui_大小", "大小", "Size")
        self._add_translation("ui_创建时间", "创建时间", "Creation Time")
        self._add_translation("ui_文件名", "文件名", "Filename")
        self._add_translation("ui_视觉分析", "视觉分析", "Visual Analysis")
        self._add_translation("ui_OCR识别", "OCR识别", "OCR Recognition")
        self._add_translation("ui_复制", "复制", "Copy")
        self._add_translation("ui_移动", "移动", "Move")
        self._add_translation("ui_自定义提示词：", "自定义提示词：", "Custom Prompt:")
        self._add_translation("ui_请选择", "请选择", "Please Select")
        self._add_translation("ui_参考选项：", "参考选项：", "Reference Options:")
        self._add_translation("ui_准备中!", "准备中!", "Preparing!")
        self._add_translation("ui_发送", "发送", "Send")
        self._add_translation("ui_取消", "取消", "Cancel")
        self._add_translation("ui_下一步", "下一步", "Next")
        self._add_translation("ui_AI命名", "AI命名", "AI Naming")
        self._add_translation("ui_已选择3个支持的文件", "已选择3个支持的文件", "3 supported files selected")
        self._add_translation("ui_命名标准（非必选）：", "命名标准（非必选）：", "Naming Standards (Optional):")
        self._add_translation("ui_自定义提示词（非必选）：", "自定义提示词（非必选）：", "Custom Prompt (Optional):")
        self._add_translation("ui_请输入...", "请输入...", "Please enter...")
        self._add_translation("ui_清空", "清空", "Clear")
        self._add_translation("ui_VIP：", "VIP：", "VIP:")
        self._add_translation("ui_前往官网", "前往官网", "Visit Website")
        self._add_translation("ui_充值", "充值", "Recharge")
        self._add_translation("ui_机器码：", "机器码：", "Machine Code:")
        self._add_translation("ui_API Server：", "API Server：", "API Server:")
        self._add_translation("ui_API Key：", "API Key：", "API Key:")
        self._add_translation("ui_模型名：", "模型名：", "Model Name:")
        self._add_translation("ui_语言：", "语言：", "Language:")
        self._add_translation("ui_保存", "保存", "Save")
        self._add_translation("ui_存储目录不能为空", "存储目录不能为空!", "The storage directory cannot be empty!")
        self._add_translation("ui_已完成", "已完成 ", "Process ")
        self._add_translation("完成", "完成 ", "Completed!")
        self._add_translation("文件整理完成，已保存到：", "文件整理完成，已保存到：", "File organization complete, saved to:")
        self._add_translation("重命名完成", "重命名完成", "Rename Complete")
        self._add_translation("一键告别文件杂乱。你的文件，文件禅来管理", "一键告别文件杂乱。你的文件，文件禅来管理", "Say goodbye to file clutter with one click. Your files, managed by FileNeatAI")

        #---- 自己增加的翻译 ----


        
        # 语言选择弹窗翻译
        self._add_translation("language_selection_title", "请选择语言", "Please select a language")
        self._add_translation("language_selection_chinese", "中文(简体)", "中文(简体)")
        self._add_translation("language_selection_english", "English", "English")
        self._add_translation("language_selection_ok", "确定", "OK")
        self._add_translation("language_selection_cancel", "取消", "Cancel")
        
        # Add more translations as needed
        
    def _add_translation(self, key, chinese_text, english_text):
        """Add a translation entry"""
        self._translations["chinese"][key] = chinese_text
        self._translations["english"][key] = english_text
        
    def get_text(self, key):
        """Get translated text for the current language"""
        if key in self._translations[self._current_language]:
            return self._translations[self._current_language][key]
        # Return the key itself if translation not found
        return key
        
    def get_current_language(self):
        """Get the current language"""
        return self._current_language
        
    def set_language(self, language):
        """Set the current language and emit signal"""
        if language in self._translations and language != self._current_language:
            self._current_language = language
            self.language_changed.emit(language)
            
    def add_custom_translation(self, key, chinese_text, english_text):
        """Add a custom translation at runtime"""
        self._add_translation(key, chinese_text, english_text)

# Create a singleton instance
translation_manager = TranslationManager()

# Convenience function to get translated text
def tr(key):
    return translation_manager.get_text(key) 