import requests
import platform
import json
import base64
from Crypto.Cipher import AES
from logger import logger
import urllib3

# Suppress InsecureRequestWarning
urllib3.disable_warnings(urllib3.exceptions.InsecureRequestWarning)

import lib.common as Com

gateway = 'https://apicdn.fileneatapi.top'
AES_KEY = 'DBt3xT74gojl2Doo'
AES_IV = 'DBt3xT74gojl2Doo'



def getCountry():
    url = 'https://ipinfo.io/json'
    try:
        reqtext = requests.get(url, timeout=10).json()
        return reqtext['country']
    except:
        return 'CN'

def getGateway():
    api = gateway
    logger.info("API Gateway: {0}".format(api))
    return api

def getInfo(code):
    gateway = getGateway()
    api = "{0}/api/info".format(gateway)
    osinfo = platform.platform()
    data = {'machine_code': code, 'osinfo': osinfo}
    req = requests.post(api, data=data, verify=False).json()
    if req['code'] == 0:
        return True, json.loads(cbc_decrypt(req['data']))
    else:
        return False, req['message']


def consume(code, islocal):
    '''
    消费次数的
    :param code:
    :param islocal:
    :return:
    '''
    gateway = getGateway()
    api = "{0}/api/consume".format(gateway)
    data = {'machine_code': code, 'islocal': 1 if islocal else 0}
    req = requests.post(api, data=data, verify=False).json()
    if req['code'] == 0:
        return True ,req
    else:
        return False, req['message']


def consumefilenum(code, filenum):
    '''
    消费文件数量的
    :param code:
    :param islocal:
    :return:
    '''
    gateway = getGateway()
    api = "{0}/api/consumefilenum".format(gateway)
    data = {'machine_code': code, 'filenum': filenum}
    req = requests.post(api, data=data, verify=False).json()
    if req['code'] == 0:
        return True ,req
    else:
        return False, req['message']



def getKey(code, type='kimi'):
    gateway = getGateway()
    api = "{0}/api/fucked?type={1}".format(gateway, type)
    data = {'machine_code': code}
    req = requests.post(api, data=data, verify=False).json()
    if req['code'] == 0:
        return True ,req
    else:
        return False, req['message']



def cbc_decrypt(ciphertext):
    """
    AES-CBC 解密
    密文的前 16 个字节为 iv
    """
    # Handle both string and bytes input
    if isinstance(ciphertext, str):
        ciphertext = base64.b64decode(ciphertext)
    elif isinstance(ciphertext, bytes):
        # If already bytes, ensure it's properly base64 decoded
        try:
            ciphertext = base64.b64decode(ciphertext.decode('utf-8'))
        except:
            # If decoding fails, assume it's already decoded
            pass
    
    mode = AES.new(AES_KEY.encode(), AES.MODE_CBC, AES_IV.encode())
    plaintext = mode.decrypt(ciphertext).decode('UTF-8')
    return plaintext[:-ord(plaintext[-1])]



if __name__ == '__main__':
    pass