# -*- coding: utf-8 -*-
"""
llama_cpp_rthook.py - PyInstaller 运行时钩子
确保打包后 llama-cpp-python 能正确找到它的 DLL 文件（ggml.dll, llama.dll 等）
"""

import os
import sys

if getattr(sys, 'frozen', False):
    # PyInstaller 打包环境
    base_dir = getattr(sys, '_MEIPASS', os.path.dirname(sys.executable))
    
    # llama_cpp DLL 可能在以下位置
    dll_search_dirs = [
        os.path.join(base_dir, 'llama_cpp', 'lib'),
        os.path.join(base_dir, '_internal', 'llama_cpp', 'lib'),
        os.path.join(base_dir, 'llama_cpp'),
        base_dir,
    ]
    
    for dll_dir in dll_search_dirs:
        if os.path.exists(dll_dir):
            # Windows 10+ 支持 os.add_dll_directory
            if hasattr(os, 'add_dll_directory'):
                try:
                    os.add_dll_directory(dll_dir)
                except OSError:
                    pass
            
            # 同时加入 PATH 环境变量（兼容旧版 Windows）
            current_path = os.environ.get('PATH', '')
            if dll_dir not in current_path:
                os.environ['PATH'] = dll_dir + os.pathsep + current_path
